#ifndef __DM_I2C_H__
#define __DM_I2C_H__

///////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef DM_WINCE

#define DM_WINCE_I2C_STAT_TABLE_ENTRIES             1024
#define DM_WINCE_I2C_STAT_MAX_CHANNELS              8
#define DM_WINCE_I2C_STAT_ALL_CHANNELS              0xFF

typedef struct
{
    UINT8 bDeviceIndex;
    UINT8 bAddr;
    UINT8 bNumBytes;
    UINT8 bIsRead;
    UINT32 lElapsedTicks;
} DM_WINCE_I2C_STAT_ENTRY;

struct DM_WINCE_I2C_STAT_CHANNEL
{
    BOOL bStatsEnabled;
    UINT32 lStatTableCount;
    DM_WINCE_I2C_STAT_ENTRY StatTable[DM_WINCE_I2C_STAT_TABLE_ENTRIES];
};

void DmResetStatsI2C( UINT8 bChannel );
void DmEnableStatsI2C( UINT8 bChannel, BOOL bEnable );
void DmPrintStatsI2C( UINT8 bChannel );
void DmAddStatI2C( UINT8 bChannel, DM_WINCE_I2C_STAT_ENTRY* pEntry );
BOOL DmIsEnabledStatsI2C( UINT8 bChannel );

INT32 DmWinI2cDeviceProcessInput(UINT32 inst, UINT32 cmd, UINT8 * pData, UINT32 * pDataBytes);

#endif

//DM virtual I2C buses
enum
{
    DM_VIRTUAL_I2C_BUS1 = 0,
    DM_VIRTUAL_I2C_BUS2,
    DM_VIRTUAL_I2C_BUS3,
    DM_VIRTUAL_I2C_BUS4,
    DM_VIRTUAL_I2C_BUS5,
    DM_VIRTUAL_I2C_BUS6,
    DM_VIRTUAL_I2C_BUS7,
    DM_VIRTUAL_I2C_BUS8,
    DM_VIRTUAL_I2C_BUS9,
    DM_VIRTUAL_I2C_BUS10,
    DM_VIRTUAL_I2C_BUS11,
    DM_VIRTUAL_I2C_BUS12,
    DM_VIRTUAL_I2C_BUS13,
    DM_VIRTUAL_I2C_BUS14,
    DM_VIRTUAL_I2C_BUS15,
    DM_VIRTUAL_I2C_BUS16,
    DM_VIRTUAL_I2C_BUS17,
    DM_VIRTUAL_I2C_BUS18,
    DM_VIRTUAL_I2C_BUS19,
    DM_VIRTUAL_I2C_BUS20,
    DM_VIRTUAL_I2C_BUS21,
    DM_VIRTUAL_I2C_BUS22,
    DM_VIRTUAL_I2C_BUS23,
    DM_VIRTUAL_I2C_BUS24,
    DM_VIRTUAL_I2C_BUS25,
    DM_VIRTUAL_I2C_BUS26,
    DM_VIRTUAL_I2C_BUS27,
    DM_VIRTUAL_I2C_BUS28,
    DM_VIRTUAL_I2C_BUS29,
    DM_VIRTUAL_I2C_BUS30,
    DM_MAX_VIRTUAL_I2C_BUSES
};

///////////////////////////////////////////////////////////////////////////////

// Note: the upper bits of the type byte are abused to hold options bits
// Should not be a problem since we shouldn't have too many types.
#define I2C_OPT_NO_SUBADDR  0x80
#define I2C_OPT_IGNORE_ERR	0x40
#define I2C_OPT_NO_ADDR     I2C_OPT_NO_SUBADDR
#define I2C_OPT_NO_LOCK     0x10
#define I2C_TYPE_MASK       0x0F
#define I2C_OPT_MASK        (~I2C_TYPE_MASK)

///////////////////////////////////////////////////////////////////////////////

typedef void (*I2CFUNC)(void);
typedef UINT16 (*I2CTESTFUNC)(void);

extern UINT32 I2CLockId;
extern UINT32 I2CLockId2;

typedef enum
{
    I2C_ADDR_DEV8_SUB8,
    I2C_ADDR_DEV8_SUB16,
    I2C_ADDR_DEV16_SUB8
} I2CADDRTYPE;

//I2C write steps
enum
{
    I2C_WRITE_STEP_SEND_DEV_ADDRESS_1 = 0,
    I2C_WRITE_STEP_SEND_SUB_ADDRESS_1,
    I2C_WRITE_STEP_SEND_SUB_ADDRESS_2,
    I2C_WRITE_STEP_SEND_DATA,
    I2C_WRITE_STEP_COMPLETE
};

//I2C read steps
enum
{
    I2C_READ_STEP_SEND_DEV_ADDRESS_1 = 10,
    I2C_READ_STEP_SEND_SUB_ADDRESS_1,
    I2C_READ_STEP_SEND_SUB_ADDRESS_2,
    I2C_READ_STEP_SEND_START_AFTER_SUBADDRESS,
    I2C_READ_STEP_SEND_DEV_ADDRESS_1_READ,
    I2C_READ_STEP_WAIT_RECEIVER_MODE,
    I2C_READ_STEP_SEND_DATA,
    I2C_READ_STEP_COMPLETE
};

#define DM_I2C_INVALID_7BIT_ADDRESS_ERROR   0xF0

// I2C addrs typically 7 or 10 bits
// subaddrs 8 or 16 bits
// devaddr      subaddr
// UINT8        UINT8
// UINT8        UINT16
// UINT16       UINT8
// UINT16       UINT16
typedef struct
{
    union
    {
        UINT32 raw;
        struct
        {
            UINT8 type;
            UINT8 devAddr;
            UINT8 subAddr;
            UINT8 pad;
        } addr;
        struct
        {
            UINT8 type;
            UINT8 devAddr;
            UINT8 subAddr;
            UINT8 pad;
        } dev8sub8;
        struct
        {
            UINT8 type;
            UINT8 devAddr;
            UINT16 subAddr;
        } dev8sub16;
        struct
        {
            UINT8 type;
            UINT16 devAddr;
            UINT8 subAddr;
        } dev16sub8;
        struct
        {
            UINT8 type;
            UINT8 devAddr;
            UINT8 pad1;
            UINT8 pad2;
        } dev8sub0;
    } u;
}I2CADDR;

// Example usage: 7-bit device addr, 8-bit sub address
// I2CADDR i2cAddr;
// i2cAddr.u.addr.type = I2C_ADDR_DEV8_SUB8;
// i2Addr.u.dev8sub8.dev = 0x42;
// i2Addr.u.dev8sub8.sub = 0x03;
// DmI2CWriteBlock(0, i2cAddr, pSrc, byteCnt);
//
// in DmI2CWriteBlock:
// switch(i2cAddr.u.addr.type)

///////////////////////////////////////////////////////////////////////////////

// This could support both built-in controllers and bit-banging I2C busses

// common pattern is: instance, address, data pointer, byte cnt

extern INT32 DmI2CCreateBus(UINT32 bus, I2CFUNC pfSdaHigh, I2CFUNC pfSdaLow, I2CTESTFUNC pfSdaTestHigh,
            I2CFUNC pfSclHigh,  I2CFUNC pfSclLow, I2CTESTFUNC pfSclTestHigh, I2CFUNC pfReset);

INT32 DmI2CWriteSegBlock(UINT32 bus, UINT32 address, UINT8 * pSrc, UINT32 byteCnt, UINT32 SegAddress);
INT32 DmI2CWriteBlock(UINT32 bus, UINT32 address, UINT8 * pSrc, UINT32 byteCnt);
INT32 DmI2CSlaveWriteSegBlock(UINT32 bus,UINT8 * pSrc, UINT32 byteCnt);
extern INT32 DmI2CReadBlock(UINT32 bus, UINT32 address, UINT8 * pDest, UINT32 byteCnt);
INT32 DmI2CReadSegBlock(UINT32 inst, UINT32 address, UINT8 * pDest, UINT32 byteCnt, UINT32 SegAddress);
extern INT32 DmI2CLock(UINT32 bus);
extern INT32 DmI2CUnlock(UINT32 bus);
BOOL IsPreviousI2CWritePending(UINT8 );
void  DmSlaveI2CInterfaceInit(UINT8);

void I2C_InitController(UINT32 bus, UINT32 speed);

extern INT32 MyI2CInit(void);

//extern INT32 I2CCmd(UINT32 ignore, char * cmd);

// this doesn't belong here
extern UINT32 I2CLockId;
extern UINT32 I2CLockId2;
extern void DmI2CInterfaceInit(UINT8 NumBus);

#define ERR_I2C_ILLEGAL_BUS -3
#define ERR_I2C_TIMEOUT -2
#define ERR_I2C_UNEXPECTED_EVENT -1
#define ERR_I2C_ILLEGAL_LENGTH -4
#define ERR_I2C_ILLEGAL_STATE -5
#define ERR_I2C_ILLEGAL_MODE -6
#define ERR_I2C_ILLEGAL_SLAVE_ADDRESS -7

enum
{
    DM_WINCE_I2C_ERROR_WRITE_FAILED = 0,
    DM_WINCE_I2C_ERROR_READ_FAILED,
    MAX_DM_WINCE_I2C_ERRORS
};

// default address for processors used as I2C slaves
#define DEFAULT_I2C_SLAVE_ADDRESS 0x5A
#ifdef __cplusplus
}
#endif

//#define DM_ENABLE_I2C_DEBUG    1

#ifdef DM_ENABLE_I2C_DEBUG

#define DM_I2C_LOG_SIZE         512

typedef struct
{
    UINT8 bChipAddr;
    UINT8 bSubAddr;
    UINT8 bCount;
    UINT8 bWrite;
} DM_I2C_LOG;


extern DM_I2C_LOG g_DmLogTableI2C[DM_I2C_LOG_SIZE];
extern UINT8 g_DmLogCountI2C;
extern UINT8 g_DmLogEnabledI2C;
extern UINT8 g_DmLogBusI2C;

void DmClearLogI2C( void );
void DmEnableLogI2C( UINT8 bEnable, UINT8 bBus );
void DmPrintLogI2C( void );

#endif

#endif  //__DM_I2C_H__
